/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskResolver;
import filenet.vw.apps.taskman.VWTaskXMLErrorHandler;
import filenet.vw.apps.taskman.resources.VWResource;
import filenet.vw.base.XMLHelper;
import filenet.vw.sysutils.UTFBOMHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class VWTaskXMLHandler {
    private Node m_rootNode = null;
    protected static final String XMLPreamble = "<?xml version='1.0' encoding='UTF-8'?>\n<!DOCTYPE TaskManagerDefinition>\n<TaskManagerDefinition\n";
    public static final String BASE_INDENT = "\t";
    public static final String BUMP_INDENT = "\t";

    public VWTaskXMLHandler(String fileName) throws IOException, SAXException, VWException, NumberFormatException {
        File theFile = new File(fileName);
        if (UTFBOMHandler.isBOMPresent(theFile)) {
            UTFBOMHandler.removeBOMandWriteToFile(theFile);
        }
        if (theFile != null && theFile.exists()) {
            FileInputStream istream = null;
            try {
                istream = new FileInputStream(fileName);
                InputStreamReader isr = new InputStreamReader((InputStream)istream, "UTF8");
                BufferedReader bufferedReader = new BufferedReader(isr);
                Document doc = XMLHelper.parseDocumentViaDOM(new InputSource(bufferedReader), new VWTaskResolver(), new VWTaskXMLErrorHandler(), false);
                this.m_rootNode = doc.getDocumentElement();
                this.m_rootNode.normalize();
            }
            catch (SAXParseException err) {
                String errString = VWResource.ParsingError + ", " + VWResource.Line + " " + err.getLineNumber() + ", uri " + err.getSystemId() + "\n" + "   " + err.getMessage();
                throw new VWException("vw.apps.taskman.VWTaskmanXMLParseError", "XML Parsing error: {0}.  XML path: {1}", errString, fileName);
            }
            catch (Exception e) {
                throw new VWException("vw.apps.taskman.VWTaskmanReadFromFileError", "XML Parsing error: {0}. XML path: {1}", e.getMessage(), fileName);
            }
            finally {
                if (istream != null) {
                    try {
                        ((InputStream)istream).close();
                    }
                    catch (Exception E) {}
                }
            }
        }
    }

    static String getXMLString(Node aNode) {
        NodeList childNodes = aNode.getChildNodes();
        if (childNodes == null) {
            return null;
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 3) continue;
            return childNode.getNodeValue();
        }
        return null;
    }

    public static String toXMLString(String buf) {
        return XMLHelper.toXMLString(buf);
    }

    static String booleanToString(boolean val) {
        if (val) {
            return "true";
        }
        return "false";
    }

    static boolean stringToBoolean(String val) throws VWException {
        if (val == null) {
            return false;
        }
        if (val.equals("true")) {
            return true;
        }
        if (val.equals("false")) {
            return false;
        }
        throw new VWException("vw.api.VWBooleanTypeBadString", "String form of the boolean type is invalid: {0}", val);
    }

    public Node getRootNode() {
        return this.m_rootNode;
    }

    public String getXMLForTopLevelNode(String nodeName) {
        StringBuffer buffer = new StringBuffer();
        VWTaskXMLHandler.nodeToXML(VWTaskXMLHandler.getNodeNamed(this.m_rootNode, nodeName), buffer, "\t");
        return buffer.toString();
    }

    public static Node getNodeNamed(Node parentNode, String name) {
        if (parentNode == null) {
            return null;
        }
        NodeList nodeList = parentNode.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (name.compareTo(node.getNodeName()) != 0) continue;
                return node;
            }
        }
        return null;
    }

    public static Node[] getNodesNamed(Node parentNode, String name) {
        if (parentNode == null) {
            return null;
        }
        NodeList nodeList = parentNode.getChildNodes();
        if (nodeList != null) {
            Vector<Node> nodes = new Vector<Node>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (name.compareTo(node.getNodeName()) != 0) continue;
                nodes.addElement(node);
            }
            if (nodes.size() > 0) {
                Object[] nodeArray = new Node[nodes.size()];
                nodes.copyInto(nodeArray);
                return nodeArray;
            }
        }
        return null;
    }

    public static void nodeToXML(Node node, StringBuffer buffer, String indent) {
        if (node == null) {
            return;
        }
        short nNodeType = node.getNodeType();
        switch (nNodeType) {
            case 9: {
                buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                VWTaskXMLHandler.nodeToXML(((Document)node).getDocumentElement(), buffer, "\t");
                break;
            }
            case 1: {
                boolean useDefaultNS = false;
                String nodeName = ((Element)node).getTagName();
                buffer.append(indent).append("<").append(nodeName);
                NamedNodeMap attributes = node.getAttributes();
                if (attributes != null) {
                    for (int nIndex = 0; nIndex < attributes.getLength(); ++nIndex) {
                        buffer.append(" ").append(attributes.item(nIndex).getNodeName()).append("=\"").append(VWTaskXMLHandler.toXMLString(attributes.item(nIndex).getNodeValue())).append("\"");
                    }
                }
                buffer.append(">\n");
                NodeList childNodes = node.getChildNodes();
                if (childNodes != null) {
                    for (int nIndex = 0; nIndex < childNodes.getLength(); ++nIndex) {
                        VWTaskXMLHandler.nodeToXML(childNodes.item(nIndex), buffer, indent + "\t");
                    }
                }
                buffer.append(indent).append("</").append(nodeName).append(">\n");
                break;
            }
            case 4: {
                buffer.append("<![CDATA[").append(node.getNodeValue()).append("]]>");
                break;
            }
            case 3: {
                String newText = node.getNodeValue().trim();
                if (newText.indexOf("\n") >= 0 || newText.length() <= 0) break;
                buffer.append(VWTaskXMLHandler.toXMLString(newText));
                break;
            }
            case 7: {
                buffer.append("<?");
                String text = node.getNodeValue();
                if (text != null && text.length() > 0) {
                    buffer.append(text);
                }
                buffer.append("?>");
                break;
            }
        }
    }
}

